/*

Note: Much of this code is adapted from Apple's developer example, Goodbye World.

*/

/***********************************/
// SAVING AND RETRIEVING PREFERENCES
/***********************************/

// setup() is run when the body loads.  It checks to see if there is a preference for this widget
// and if so, applies the preference to the widget.

function setup()
{
	if(window.widget)		// always check to make sure that you are running in Dashboard
	{
		// The preferences are retrieved:
		var ftpath = widget.preferenceForKey("ftpath");
		var fpath = widget.preferenceForKey("fpath");
		var wpop = widget.preferenceForKey("wpop");

		//if (ftpath && fpath > 0)  // if the retrieved preferences are not empty,
		if (ftpath != fpath)
		{											// they are restored.
			feelingText.src = ftpath;
			feelingImage.src = fpath;
			worldPopup.selectedIndex = wpop;
			
            if (wpop == 16)
			{
				loadRandom();
			}			
		}
		
		widget.onshow = function OnShow() { // when Dashboard triggered	 
            if (wpop == 16)
			{
				loadRandom();
			}
        }
		
	}
}

function loadRandom()
{
	nowrand=Math.round(Math.random()*15)
	
	switch( nowrand+1 )					// find out which option was chosen
		{
			case 1: 									// if option #1 ("Hello, World!")	
				feelingText.src="Images/tNone.png";
				feelingImage.src="Images/none.png";
				break;
			case 2:										// if option #2 ("Goodbye, World!")
				feelingText.src="Images/tHappy.png";		// change the front text to "Goodbye, World!" & adjust the style
				feelingImage.src="Images/happy.png";
				break;
			case 3:										// if option #2 ("Goodbye, World!")
				feelingText.src="Images/tSad.png";		// change the front text to "Goodbye, World!" & adjust the style
				feelingImage.src="Images/sad.png";
				break;
			case 4:										// if option #2 ("Goodbye, World!")
				feelingText.src="Images/tFunny.png";		// change the front text to "Goodbye, World!" & adjust the style
				feelingImage.src="Images/funny.png";
				break;
			case 5:										// if option #2 ("Goodbye, World!")
				feelingText.src="Images/tDepressed.png";		// change the front text to "Goodbye, World!" & adjust the style
				feelingImage.src="Images/depressed.png";
				break;
			case 6: 									// if option #1 ("Hello, World!")	
				feelingText.src="Images/tBored.png";
				feelingImage.src="Images/bored.png";
				break;
			case 7: 									// if option #1 ("Hello, World!")	
				feelingText.src="Images/tAngry.png";
				feelingImage.src="Images/angry.png";
				break;
			case 8: 									// if option #1 ("Hello, World!")	
				feelingText.src="Images/tCool.png";
				feelingImage.src="Images/cool.png";
				break;
			case 9: 									// if option #1 ("Hello, World!")	
				feelingText.src="Images/tDetermined.png";
				feelingImage.src="Images/determined.png";
				break;
			case 10: 									// if option #1 ("Hello, World!")	
				feelingText.src="Images/tFurious.png";
				feelingImage.src="Images/furious.png";
				break;
			case 11: 									// if option #1 ("Hello, World!")	
				feelingText.src="Images/tMischievous.png";
				feelingImage.src="Images/mischievous.png";
				break;
			case 12: 									// if option #1 ("Hello, World!")	
				feelingText.src="Images/tOptimistic.png";
				feelingImage.src="Images/optimistic.png";
				break;
			case 13: 									// if option #1 ("Hello, World!")	
				feelingText.src="Images/tShocked.png";
				feelingImage.src="Images/shocked.png";
				break;
			case 14: 									// if option #1 ("Hello, World!")	
				feelingText.src="Images/tThoughtful.png";
				feelingImage.src="Images/thoughtful.png";
				break;
			case 15: 									// if option #1 ("Hello, World!")	
				feelingText.src="Images/tStressed.png";
				feelingImage.src="Images/stressed.png";
				break;
			case 16: 									// if option #1 ("Hello, World!")	
				feelingText.src="Images/tEcstatic.png";
				feelingImage.src="Images/ecstatic.png";
				break;
		}
}


// changeWorld() is called whenever a menu item is chosen in the widget's preferences.  It queries the
// menu to find out which option was chosen, applies the change to the widget, and saves the preference.

function changeWorld(elem)
{	
		
	switch( parseInt(elem.options[elem.selectedIndex].value) )					// find out which option was chosen
	{
		case 1: 									// if option #1 ("Hello, World!")	
			feelingText.src="Images/tNone.png";
			feelingImage.src="Images/none.png";
			if(window.widget)
			{
				widget.setPreferenceForKey("Images/tNone.png","ftpath");			// and save the new preference to disk
				widget.setPreferenceForKey("Images/none.png","fpath");
				widget.setPreferenceForKey(0,"wpop");
			}
			break;
		case 2:										// if option #2 ("Goodbye, World!")
			feelingText.src="Images/tHappy.png";		// change the front text to "Goodbye, World!" & adjust the style
			feelingImage.src="Images/happy.png";
			if(window.widget)
			{
				widget.setPreferenceForKey("Images/tHappy.png","ftpath");	// and save the new preference to disk
				widget.setPreferenceForKey("Images/happy.png","fpath");
				widget.setPreferenceForKey(1,"wpop");
			}
			break;
		case 3:										// if option #2 ("Goodbye, World!")
			feelingText.src="Images/tSad.png";		// change the front text to "Goodbye, World!" & adjust the style
			feelingImage.src="Images/sad.png";
			if(window.widget)
			{
				widget.setPreferenceForKey("Images/tSad.png","ftpath");	// and save the new preference to disk
				widget.setPreferenceForKey("Images/sad.png","fpath");
				widget.setPreferenceForKey(2,"wpop");
			}
			break;
		case 4:										// if option #2 ("Goodbye, World!")
			feelingText.src="Images/tFunny.png";		// change the front text to "Goodbye, World!" & adjust the style
			feelingImage.src="Images/funny.png";
			if(window.widget)
			{
				widget.setPreferenceForKey("Images/tFunny.png","ftpath");	// and save the new preference to disk
				widget.setPreferenceForKey("Images/funny.png","fpath");
				widget.setPreferenceForKey(3,"wpop");
			}
			break;
		case 5:										// if option #2 ("Goodbye, World!")
			feelingText.src="Images/tDepressed.png";		// change the front text to "Goodbye, World!" & adjust the style
			feelingImage.src="Images/depressed.png";
			if(window.widget)
			{
				widget.setPreferenceForKey("Images/tDepressed.png","ftpath");	// and save the new preference to disk
				widget.setPreferenceForKey("Images/depressed.png","fpath");
				widget.setPreferenceForKey(4,"wpop");
			}
			break;
		case 6: 									// if option #1 ("Hello, World!")	
			feelingText.src="Images/tBored.png";
			feelingImage.src="Images/bored.png";
			if(window.widget)
			{
				widget.setPreferenceForKey("Images/tBored.png","ftpath");			// and save the new preference to disk
				widget.setPreferenceForKey("Images/bored.png","fpath");
				widget.setPreferenceForKey(5,"wpop");
			}
			break;
		case 7: 									// if option #1 ("Hello, World!")	
			feelingText.src="Images/tAngry.png";
			feelingImage.src="Images/angry.png";
			if(window.widget)
			{
				widget.setPreferenceForKey("Images/tAngry.png","ftpath");			// and save the new preference to disk
				widget.setPreferenceForKey("Images/angry.png","fpath");
				widget.setPreferenceForKey(6,"wpop");
			}
			break;
		case 8: 									// if option #1 ("Hello, World!")	
			feelingText.src="Images/tCool.png";
			feelingImage.src="Images/cool.png";
			if(window.widget)
			{
				widget.setPreferenceForKey("Images/tCool.png","ftpath");			// and save the new preference to disk
				widget.setPreferenceForKey("Images/cool.png","fpath");
				widget.setPreferenceForKey(7,"wpop");
			}
			break;
		case 9: 									// if option #1 ("Hello, World!")	
			feelingText.src="Images/tDetermined.png";
			feelingImage.src="Images/determined.png";
			if(window.widget)
			{
				widget.setPreferenceForKey("Images/tDetermined.png","ftpath");			// and save the new preference to disk
				widget.setPreferenceForKey("Images/determined.png","fpath");
				widget.setPreferenceForKey(8,"wpop");
			}
			break;
		case 10: 									// if option #1 ("Hello, World!")	
			feelingText.src="Images/tFurious.png";
			feelingImage.src="Images/furious.png";
			if(window.widget)
			{
				widget.setPreferenceForKey("Images/tFurious.png","ftpath");			// and save the new preference to disk
				widget.setPreferenceForKey("Images/furious.png","fpath");
				widget.setPreferenceForKey(9,"wpop");
			}
			break;
		case 11: 									// if option #1 ("Hello, World!")	
			feelingText.src="Images/tMischievous.png";
			feelingImage.src="Images/mischievous.png";
			if(window.widget)
			{
				widget.setPreferenceForKey("Images/tMischievous.png","ftpath");			// and save the new preference to disk
				widget.setPreferenceForKey("Images/mischievous.png","fpath");
				widget.setPreferenceForKey(10,"wpop");
			}
			break;
		case 12: 									// if option #1 ("Hello, World!")	
			feelingText.src="Images/tOptimistic.png";
			feelingImage.src="Images/optimistic.png";
			if(window.widget)
			{
				widget.setPreferenceForKey("Images/tOptimistic.png","ftpath");			// and save the new preference to disk
				widget.setPreferenceForKey("Images/optimistic.png","fpath");
				widget.setPreferenceForKey(11,"wpop");
			}
			break;
		case 13: 									// if option #1 ("Hello, World!")	
			feelingText.src="Images/tShocked.png";
			feelingImage.src="Images/shocked.png";
			if(window.widget)
			{
				widget.setPreferenceForKey("Images/tShocked.png","ftpath");			// and save the new preference to disk
				widget.setPreferenceForKey("Images/shocked.png","fpath");
				widget.setPreferenceForKey(12,"wpop");
			}
			break;
		case 14: 									// if option #1 ("Hello, World!")	
			feelingText.src="Images/tThoughtful.png";
			feelingImage.src="Images/thoughtful.png";
			if(window.widget)
			{
				widget.setPreferenceForKey("Images/tThoughtful.png","ftpath");			// and save the new preference to disk
				widget.setPreferenceForKey("Images/thoughtful.png","fpath");
				widget.setPreferenceForKey(13,"wpop");
			}
			break;
		case 15: 									// if option #1 ("Hello, World!")	
			feelingText.src="Images/tStressed.png";
			feelingImage.src="Images/stressed.png";
			if(window.widget)
			{
				widget.setPreferenceForKey("Images/tStressed.png","ftpath");			// and save the new preference to disk
				widget.setPreferenceForKey("Images/stressed.png","fpath");
				widget.setPreferenceForKey(14,"wpop");
			}
			break;
		case 16: 									// if option #1 ("Hello, World!")	
			feelingText.src="Images/tEcstatic.png";
			feelingImage.src="Images/ecstatic.png";
			if(window.widget)
			{
				widget.setPreferenceForKey("Images/tEcstatic.png","ftpath");			// and save the new preference to disk
				widget.setPreferenceForKey("Images/ecstatic.png","fpath");
				widget.setPreferenceForKey(15,"wpop");
			}
			break;
		case 17:
			if(window.widget)
			{
				widget.setPreferenceForKey(16,"wpop");
				}
				break;
		
	}
} 


/*********************************/
// HIDING AND SHOWING PREFERENCES
/*********************************/

// showPrefs() is called when the preferences flipper is clicked upon.  It freezes the front of the widget,
// hides the front div, unhides the back div, and then flips the widget over.

function showPrefs()
{
	var front = document.getElementById("front");
	var back = document.getElementById("back");
	
	if (window.widget)
		widget.prepareForTransition("ToBack");		// freezes the widget so that you can change it without the user noticing
	
	front.style.display="none";		// hide the front
	back.style.display="block";		// show the back
	
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);		// and flip the widget over	

	document.getElementById('fliprollie').style.display = 'none';  // clean up the front side - hide the circle behind the info button

}


// hidePrefs() is called by the done button on the back side of the widget.  It performs the opposite transition
// as showPrefs() does.

function hidePrefs()
{
	var front = document.getElementById("front");
	var back = document.getElementById("back");
	
	if (window.widget)
		widget.prepareForTransition("ToFront");		// freezes the widget and prepares it for the flip back to the front
	
	back.style.display="none";			// hide the back
	front.style.display="block";		// show the front
	
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);		// and flip the widget back to the front
}


// PREFERENCE BUTTON ANIMATION (- the pref flipper fade in/out)

var flipShown = false;		// a flag used to signify if the flipper is currently shown or not.


// A structure that holds information that is needed for the animation to run.
var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, firstElement:null, timer:null};


// mousemove() is the event handle assigned to the onmousemove property on the front div of the widget. 
// It is triggered whenever a mouse is moved within the bounds of your widget.  It prepares the
// preference flipper fade and then calls animate() to performs the animation.

function mousemove (event)
{
	if (!flipShown)			// if the preferences flipper is not already showing...
	{
		if (animation.timer != null)			// reset the animation timer value, in case a value was left behind
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13; 		// set it back one frame
		
		animation.duration = 500;												// animation time, in ms
		animation.starttime = starttime;										// specify the start time
		animation.firstElement = document.getElementById ('flip');		// specify the element to fade
		animation.timer = setInterval ("animate();", 13);						// set the animation function
		animation.from = animation.now;											// beginning opacity (not ness. 0)
		animation.to = 1.0;														// final opacity
		animate();																// begin animation
		flipShown = true;														// mark the flipper as animated
	}
}

// mouseexit() is the opposite of mousemove() in that it preps the preferences flipper
// to disappear.  It adds the appropriate values to the animation data structure and sets the animation in motion.

function mouseexit (event)
{
	if (flipShown)
	{
		// fade in the flip widget
		if (animation.timer != null)
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13;
		
		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById ('flip');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 0.0;
		animate();
		flipShown = false;
	}
}


// animate() performs the fade animation for the preferences flipper. It uses the opacity CSS property to simulate a fade.

function animate()
{
	var T;
	var ease;
	var time = (new Date).getTime();
		
	
	T = limit_3(time-animation.starttime, 0, animation.duration);
	
	if (T >= animation.duration)
	{
		clearInterval (animation.timer);
		animation.timer = null;
		animation.now = animation.to;
	}
	else
	{
		ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
		animation.now = computeNextFloat (animation.from, animation.to, ease);
	}
	
	animation.firstElement.style.opacity = animation.now;
}


// these functions are utilities used by animate()

function limit_3 (a, b, c)
{
    return a < b ? b : (a > c ? c : a);
}

function computeNextFloat (from, to, ease)
{
    return from + (to - from) * ease;
}

// these functions are called when the info button itself receives onmouseover and onmouseout events

function enterflip(event)
{
	document.getElementById('fliprollie').style.display = 'block';
}

function exitflip(event)
{
	document.getElementById('fliprollie').style.display = 'none';
}